## Cisco Secure Firewall Threat Defense: Remote Access VPN Overview

---

### Core Principles

- Uses the Cisco Secure Firewall ASA engine for remote access VPNs.
- Most SSL VPN settings (IP assignment, split tunneling) are similar to ASA.

---

### Certificate Requirements

- **Identity Certificate Needed**
    - Required for SSL VPN headend authentication.
- **Default Behavior**
    - No self-signed certificate installed by default.
- **Options:**
    - Create a self-signed certificate.
    - Enroll with an external CA for a verifiable certificate.
- **Best Practice**
    - Use a CA-provisioned certificate for production environments.

---

### User Authentication & Connection Profiles

- **Profile Selection**
    - Users may choose a connection profile from a drop-down or group URL.
    - DefaultWEBVPNGroup assigned if no profile is chosen (requires configuration).
- **Authentication Methods**
    - Local database
    - External AAA (RADIUS, LDAP)
    - SAML protocol (Single Sign-On)
- **Process**
    - Credentials sent to the Threat Defense device and validated.
    - Policies applied upon successful authentication.

---

### IP Address Assignment Options

- **Methods:**
    - IP address pool assigned to connection profile (local or DHCP).
    - IP address pool assigned via group policy (for differentiated access).
    - Per-user IP address configured on the AAA server (enables unique tracking/policies).

---

### Traffic Management

#### Full Tunnel vs. Split Tunneling

- **Default:**
    - All client IP traffic forwarded over the VPN tunnel.
- **Split Tunneling:**
    - Only specified internal traffic goes through VPN; other traffic (e.g., internet) bypasses tunnel.
    - **Advantages:** Better app performance for non-VPN traffic.
    - **Risks:** Reduced protection for client and risk of the client acting as a relay.

---

### Access Control

- **Default:**
    - VPN traffic subject to Access Control Policy (ACP).
- **Options:**
    - Filter VPN traffic using interface ACP (like regular traffic).
    - Apply IP filters (ACLs) within group policies for granular access control.

---

### Configuration Steps (via Cisco Secure Firewall Management Center)

1. **Create Remote Access VPN Policy**
    - Name policy and assign to managed device (5-step wizard).
2. **Create Connection Profile**
    - Name profile.
    - Select AAA method.
    - Choose IP address assignment method.
3. **Group Policy**
    - Create/assign default group policy.
    - Optionally configure split tunneling and override VPN address pool.
4. **Upload Secure Client Image**
    - Select or upload Cisco Secure Client (formerly AnyConnect) image.
5. **Enable SSL VPN**
    - Enable on security zone or interface group.
    - Select or enroll for a certificate.
6. **NAT Exemption**
    - Configure NAT exemption to prevent translation for VPN traffic.
7. **Configure ACP**
    - Explicitly allow VPN traffic.
8. **Save & Deploy**
    - Save policy and deploy to managed devices.

---

### NAT Rules Example

- **General Rule:**
    - Translates all internal-to-outside traffic using PAT.
- **NAT Exemption Rule:**
    - Exempts VPN client traffic to/from internal networks from translation.
    - Keeps original source/destination IPs for VPN traffic.

---

### Verifying & Troubleshooting VPN Configuration

#### Verification Steps

- Ensure SSL/TLS session establishes without protocol/cipher issues.
- Confirm user authentication is successful.
- Check group policy allows SSL VPN tunnels.
- Verify client receives IP address.
- Review logging messages (locally or via Syslog/Cisco Secure Firewall Management Center).

#### Troubleshooting Connectivity

- **Split Tunneling:**
    - Verify client routing table and ACLs for correct networks.
- **Access Control:**
    - Check ACP for permitted or blocked VPN traffic (review logs and use Packet Tracer).
- **NAT Rules:**
    - Ensure VPN traffic matches correct NAT exemption rules.
- **Routing:**
    - Confirm internal networks have routes to VPN-assigned client IP addresses.